#include <iostream>
#include <algorithm>
#include <tuple>
#include <cmath>

using namespace std;

tuple<double, int, int, int> vektori[300000];

double udaljenost(pair<int, int>& vek) {
    double x = vek.first;
    double y = vek.second;
    return sqrt(x*x+y*y);
}

int main() {
    int n;
    cin >> n;

    for (int i = 0; i<n; i++) {
        int x, y;
        cin >> x >> y;
        double ugao = atan2(y, x);
        get<0>(vektori[i]) = ugao >= 0 ? ugao : 2*M_PI + ugao;
        get<1>(vektori[i]) = x;
        get<2>(vektori[i]) = y;
        get<3>(vektori[i]) = i+1;
    }

    sort(vektori, vektori+n);  

    int l = 0, r = 1;
    pair<int, int> vek_ukupno = pair<int, int>(get<1>(vektori[0]), get<2>(vektori[0]));
    double max_dist = udaljenost(vek_ukupno);
    int l_max = 0, r_max = 0;
    while (l<n) {
        double ugao = get<0>(vektori[r]) - get<0>(vektori[l]);
        ugao = ugao < 0 ? 2*M_PI + ugao : ugao;
        while (ugao < M_PI && r != l) {
            vek_ukupno.first += get<1>(vektori[r]);
            vek_ukupno.second += get<2>(vektori[r]); 
            r++;
            if (r == n) r = 0;

            ugao = get<0>(vektori[r]) - get<0>(vektori[l]);
            ugao = ugao < 0 ? 2*M_PI + ugao : ugao;
        }

        double tren_dist = udaljenost(vek_ukupno);
        if (tren_dist > max_dist) {
            max_dist = tren_dist;
            l_max = l;
            r_max = r;
        }

        vek_ukupno.first -= get<1>(vektori[l]);
        vek_ukupno.second -= get<2>(vektori[l]); 
        l++; 
    }

    cout << (r_max >= l_max ? r_max - l_max : n - l_max + r_max) << "\n";

    for (int i = l_max; i != r_max; i++) {
        if (i == n) i = 0;
        cout << get<3>(vektori[i]) << " ";
    }

    return 0;
}